﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System.Text;


public class Popup : MonoBehaviour {

	public delegate void OnClick(int buttonIndex);


	public GameObject popup;

	public Text textTitle;
	public Text textMessage;
	public InputField inputField;

	public RawImage image;

	public GameObject buttonPrefab;
	public GameObject buttonGrayPrefab;
	public GameObject buttonContainer;


	private Popup.OnClick callback;


	// Use this for initialization
	void Start () {
		// popup.SetActive (false);
	}

	public void show(string title, string message, string button, Popup.OnClick callback)
	{
		internalShow(title, message, null, new string[] {button}, false, callback);
	}

	public void show(string title, string message, string [] buttons, Popup.OnClick callback)
	{
		internalShow(title, message, null, buttons, false, callback);
	}

	public void show(string title, string message, string [] buttons, bool isInputField, Popup.OnClick callback)
	{
		internalShow(title, message, null, buttons, true, callback);
	}

	public void show(string title, byte[] rawImage, string [] buttons, Popup.OnClick callback)
	{
		internalShow(title, null, rawImage, buttons, false, callback);
	}

	public void show(SBSLocalization.PopupKey key, string errorCode, byte[] rawImage, string [] buttons, Popup.OnClick callback)
	{
		Debug.Log("Popup Show is called");
		if (LocalizationManager.instance.GetIsReady()) {
			string localizationKey = key.ToString();
			PopupContent content = LocalizationManager.instance.GetLocalizedPopupValue(localizationKey);
			string popupTitle = content.title;
			string popupContent = content.message;
			
			if (!string.IsNullOrEmpty(errorCode)) {
				StringBuilder sb = new StringBuilder();
				sb.Append(popupContent);
				sb.Append("\n");
				sb.Append("(");
				sb.Append(errorCode);
				sb.Append(" )");

				popupContent = sb.ToString();
			}

		Debug.Log("Popup Show is called - internal Show");
			internalShow(popupTitle, popupContent, rawImage, buttons, false, callback);
		}
	}

	private void internalShow(
		string title,
		string message,
		byte[] rawImage,
		string [] buttons,
		bool isInputField,
		Popup.OnClick callback)
	{
		ClearButtons();

		textTitle.text = title;
		
		image.gameObject.SetActive(false);
		textMessage.gameObject.SetActive(false);
		inputField.gameObject.SetActive(false);

		if (rawImage != null) {
			image.gameObject.SetActive (true);

			//TODO set image

			Texture2D texture = new Texture2D(1, 1);
			texture.LoadImage (rawImage);		
			texture.Apply ();

			image.texture = texture;

			Button button = image.gameObject.GetComponent<Button>();
			button.onClick.RemoveAllListeners();
			button.onClick.AddListener(delegate{onButtonClick(99);});

		} else {
			if (isInputField == true) {
				inputField.gameObject.SetActive(true);
				inputField.text = message;
			}
			else {
				textMessage.gameObject.SetActive(true);
				textMessage.text = message;
			}
		}

		for (int i = 0; i < buttons.Length; i++) {
			GameObject btnObj	= null;
			if ((i == 0) && (buttons.Length > 1) ) {
				btnObj = Instantiate(buttonGrayPrefab) as GameObject;
			} else {
				btnObj = Instantiate(buttonPrefab) as GameObject;
			}
			Button button = btnObj.GetComponent<Button>();

			int _i = i;
			button.onClick.AddListener(delegate{onButtonClick(_i);});

			button.GetComponentInChildren<Text>().text = buttons[i];

			button.transform.SetParent(buttonContainer.transform);
			button.transform.localScale	= Vector3.one;
		}

		this.callback	= callback;

		popup.SetActive(true);
	}

	private void onButtonClick(int buttonIndex)
	{
		Debug.Log("onButtonClick: " + buttonIndex);

		popup.SetActive (false);

		if (callback != null) {
			this.callback (buttonIndex);
		}

		// callback = null; // 콜백 내에 팝업을 또 띄울경우
	}

	private void ClearButtons()
	{
		Debug.Log("ClearButtons");

		try {
			Button []items = buttonContainer.GetComponentsInChildren<Button> ();

			foreach (Button item in items) {
				DestroyImmediate(item.gameObject);
			}
		} catch (System.Exception ignore) {
		}
		
	}

	public void dismiss()
	{
		Debug.Log("dismiss");

		popup.SetActive (false);
	}
}
